uniform sampler2D texTo;
uniform sampler2D texFrom;

uniform float crossfader;
uniform float levelFrom;
uniform float levelTo;

void main()
{
	vec2 uv = gl_TexCoord[0].st;
  vec4 inFrom = texture2D(texFrom,uv.xy);
  vec4 inTo = texture2D(texTo,uv.xy);
  vec4 outColor = inFrom;
	if (crossfader < (1.0/3.0))
	{
		outColor.r = mix(inFrom.r, inTo.r, crossfader * 3.0);
	}
	else if (crossfader < (2.0 / 3.0))
	{
		outColor.r = inTo.r;
		outColor.g = mix(inFrom.g, inTo.g, (crossfader-(1.0/3.0)) * 3.0);
	}
	else
	{
		outColor.r = inTo.r;
		outColor.g = inTo.g;
		outColor.b = mix(inFrom.b, inTo.b, (crossfader - (2.0 / 3.0)) * 3.0);
	}
	gl_FragColor = outColor;  
}